/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.mapmatrix;

import java.io.Closeable;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ujmp.core.Coordinates;
import org.ujmp.core.collections.list.FastArrayList;
import org.ujmp.core.mapmatrix.DefaultMapMatrix;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.objectmatrix.stub.AbstractDenseObjectMatrix2D;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMapMatrix<K, V>
extends AbstractDenseObjectMatrix2D
implements MapMatrix<K, V> {
    private static final long serialVersionUID = 5571429371462164416L;
    private volatile boolean isIndexUpToDate = false;
    private final List<K> keyIndexList = new FastArrayList<K>();

    public AbstractMapMatrix() {
        super(0L, 2L);
    }

    @Override
    public final synchronized long[] getSize() {
        this.size[0] = this.size();
        return this.size;
    }

    @Override
    public final synchronized Object getObject(long row, long column) {
        return this.getObject(MathUtil.longToInt(row), MathUtil.longToInt(column));
    }

    @Override
    public final synchronized int indexOfKey(Object key) {
        return this.keyIndexList.indexOf(key);
    }

    @Override
    public final synchronized Object getObject(int row, int column) {
        K mapKey = this.getKey(row);
        if (column == 0) {
            return mapKey;
        }
        if (column == 1) {
            return mapKey == null ? null : this.get(mapKey);
        }
        return null;
    }

    @Override
    public final synchronized void setObject(Object value, int row, int column) {
        if (column == 0) {
            K key = this.getKey(row);
            Object oldValue = this.get(key);
            this.remove(key);
            this.put(value, oldValue);
        } else if (column == 1) {
            K key = this.getKey(row);
            this.put(key, value);
        }
    }

    @Override
    public final synchronized void setObject(Object value, long row, long column) {
        this.setObject(value, MathUtil.longToInt(row), MathUtil.longToInt(column));
    }

    @Override
    public synchronized MapMatrix<K, V> clone() {
        this.buildIndexIfNecessary();
        DefaultMapMatrix clone = new DefaultMapMatrix();
        clone.putAll(this);
        for (K key : this.keyIndexList) {
            Object value = this.get(key);
            clone.put(key, value);
        }
        return clone;
    }

    @Override
    public String getAsString(Object key) {
        return StringUtil.convert(this.get(key));
    }

    private final synchronized K getKey(int index) {
        this.buildIndexIfNecessary();
        K k = null;
        if (index >= 0 && index < this.keyIndexList.size()) {
            k = this.keyIndexList.get(index);
        }
        return k;
    }

    private synchronized void buildIndexIfNecessary() {
        if (!this.isIndexUpToDate) {
            Iterator it = this.keySet().iterator();
            while (it.hasNext()) {
                this.keyIndexList.add(it.next());
            }
            if (it instanceof Closeable) {
                try {
                    ((Closeable)((Object)it)).close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.isIndexUpToDate = true;
        }
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        this.buildIndexIfNecessary();
        return this.keyIndexList.contains(key);
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        this.buildIndexIfNecessary();
        for (K key : this.keyIndexList) {
            if (!value.equals(this.get(key))) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        final AbstractMapMatrix map = this;
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    Iterator<K> it;
                    {
                        this.it = AbstractMapMatrix.this.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        final Object k = this.it.next();
                        final Object v = AbstractMapMatrix.this.get(k);
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return k;
                            }

                            @Override
                            public V getValue() {
                                return v;
                            }

                            @Override
                            public V setValue(V value) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return map.size();
            }
        };
    }

    @Override
    public final synchronized boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final synchronized V put(K key, V value) {
        this.keyIndexList.clear();
        this.isIndexUpToDate = false;
        V v = this.putIntoMap(key, value);
        if (v != null) {
            this.fireValueChanged(Coordinates.wrap(this.indexOfKey(key), 1L), value);
        } else {
            this.fireValueChanged();
        }
        return v;
    }

    @Override
    public final synchronized void putAll(Map<? extends K, ? extends V> map) {
        for (K k : map.keySet()) {
            this.putIntoMap(k, map.get(k));
        }
        this.fireValueChanged();
    }

    @Override
    public final synchronized V remove(Object key) {
        this.keyIndexList.clear();
        this.isIndexUpToDate = false;
        V v = this.removeFromMap(key);
        this.fireValueChanged();
        return v;
    }

    @Override
    public final synchronized Collection<V> values() {
        this.buildIndexIfNecessary();
        final AbstractMapMatrix map = this;
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    Iterator<K> it;
                    {
                        this.it = AbstractMapMatrix.this.keyIndexList.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public V next() {
                        return AbstractMapMatrix.this.get(this.it.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return map.size();
            }
        };
    }

    @Override
    public final void clear() {
        this.keyIndexList.clear();
        this.isIndexUpToDate = false;
        this.clearMap();
    }

    protected abstract void clearMap();

    protected abstract V removeFromMap(Object var1);

    protected abstract V putIntoMap(K var1, V var2);
}

