/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jdbc.matrix;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.ujmp.core.listmatrix.AbstractListMatrix;
import org.ujmp.jdbc.autoclose.AutoOpenCloseConnection;
import org.ujmp.jdbc.matrix.JDBCCatalogMatrix;
import org.ujmp.jdbc.util.SQLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCCatalogListMatrix
extends AbstractListMatrix<JDBCCatalogMatrix> {
    private static final long serialVersionUID = -1738017101718658172L;
    public static final String CONNECTION = "Connection";
    public static final String URL = "URL";
    public static final String SQLDIALECT = "SQLDialect";
    public static final String DATABASENAME = "DatabaseName";
    private final Connection connection;

    public static JDBCCatalogListMatrix connectToSQLite(File file) throws SQLException {
        return new JDBCCatalogListMatrix("jdbc:sqlite:" + file.getAbsolutePath(), null, null);
    }

    protected JDBCCatalogListMatrix(String url, String username, String password) throws SQLException {
        this(new AutoOpenCloseConnection(url, username, password));
    }

    public JDBCCatalogListMatrix(Connection connection) throws SQLException {
        this.connection = connection;
        String url = connection.getMetaData().getURL();
        this.setMetaData(URL, url);
        this.setMetaData(SQLDIALECT, (Object)SQLUtil.getSQLDialect(url));
    }

    public final SQLUtil.SQLDialect getSQLDialect() {
        Object sqlDialect = this.getMetaData(SQLDIALECT);
        if (sqlDialect instanceof SQLUtil.SQLDialect) {
            return (SQLUtil.SQLDialect)((Object)this.getMetaData(SQLDIALECT));
        }
        return null;
    }

    public synchronized void removeDatabase(String database) {
        try {
            PreparedStatement st = SQLUtil.getDropDatabaseStatement(this.connection, this.getSQLDialect(), database);
            st.executeUpdate();
            st.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void addDatabase(String database) {
        try {
            PreparedStatement st = SQLUtil.getCreateDatabaseStatement(this.connection, this.getSQLDialect(), database);
            st.executeUpdate();
            st.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getCatalogName(int index) throws SQLException {
        DatabaseMetaData meta = this.connection.getMetaData();
        ResultSet rs = meta.getCatalogs();
        rs.absolute(index + 1);
        String catalogName = rs.getString(1);
        rs.close();
        return catalogName;
    }

    @Override
    public JDBCCatalogMatrix get(int index) {
        try {
            String catalogName = this.getCatalogName(index);
            JDBCCatalogMatrix matrix = new JDBCCatalogMatrix(this.connection, catalogName);
            return matrix;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean addToList(JDBCCatalogMatrix t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addToList(int index, JDBCCatalogMatrix element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JDBCCatalogMatrix removeFromList(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeFromList(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JDBCCatalogMatrix setToList(int index, JDBCCatalogMatrix element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized int size() {
        try {
            DatabaseMetaData meta = this.connection.getMetaData();
            ResultSet rs = meta.getCatalogs();
            int count = 0;
            while (rs.next()) {
                ++count;
            }
            rs.close();
            return count;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

