/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.DateParseException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import com.enterprisedt.util.debug.Logger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class OS400FileParser
extends FTPFileParser {
    private static final String DIR = "*DIR";
    private static final String DDIR = "*DDIR";
    private static final String MEM = "*MEM";
    private static final int MIN_EXPECTED_FIELD_COUNT = 6;
    private static final String DATE_FORMAT_1 = "dd'/'MM'/'yy' 'HH':'mm':'ss";
    private static final String DATE_FORMAT_2 = "dd'.'MM'.'yy' 'HH':'mm':'ss";
    private static final String DATE_FORMAT_11 = "MM'/'dd'/'yy' 'HH':'mm':'ss";
    private static final String DATE_FORMAT_12 = "MM'.'dd'.'yy' 'HH':'mm':'ss";
    private static final String DATE_FORMAT_21 = "yy'/'MM'/'dd' 'HH':'mm':'ss";
    private static final String DATE_FORMAT_22 = "yy'.'MM'.'dd' 'HH':'mm':'ss";
    private static String[] formats1 = new String[]{"dd'/'MM'/'yy' 'HH':'mm':'ss", "dd'.'MM'.'yy' 'HH':'mm':'ss"};
    private static String[] formats2 = new String[]{"MM'/'dd'/'yy' 'HH':'mm':'ss", "MM'.'dd'.'yy' 'HH':'mm':'ss"};
    private static String[] formats3 = new String[]{"yy'/'MM'/'dd' 'HH':'mm':'ss", "yy'.'MM'.'dd' 'HH':'mm':'ss"};
    private String[][] formats = new String[][]{formats1, formats2, formats3};
    private static Logger log = Logger.getLogger("OS400FileParser");
    private int formatIndex = 0;
    private Locale locale = Locale.getDefault();

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String toString() {
        return "OS400";
    }

    public boolean isValidFormat(String[] listing) {
        int count = Math.min(listing.length, 10);
        boolean dir = false;
        boolean ddir = false;
        boolean lib = false;
        boolean stmf = false;
        boolean flr = false;
        boolean file = false;
        boolean mem = false;
        for (int i = 0; i < count; ++i) {
            if (listing[i].indexOf(DIR) > 0) {
                dir = true;
                continue;
            }
            if (listing[i].indexOf("*FILE") > 0) {
                file = true;
                continue;
            }
            if (listing[i].indexOf("*FLR") > 0) {
                flr = true;
                continue;
            }
            if (listing[i].indexOf(DDIR) > 0) {
                ddir = true;
                continue;
            }
            if (listing[i].indexOf("*STMF") > 0) {
                stmf = true;
                continue;
            }
            if (listing[i].indexOf("*LIB") > 0) {
                lib = true;
                continue;
            }
            if (listing[i].indexOf(MEM) <= 0) continue;
            mem = true;
        }
        if (dir || file || ddir || lib || stmf || flr || mem) {
            return true;
        }
        log.debug("Not in OS/400 format");
        return false;
    }

    public FTPFile parse(String raw) throws DateParseException {
        String[] fields = this.split(raw);
        if (fields.length <= 0) {
            return null;
        }
        if (fields.length >= 2 && fields[1].equals(MEM)) {
            String owner = fields[0];
            String name = fields[2];
            FTPFile file = new FTPFile(raw, name, 0L, false, null);
            file.setOwner(owner);
            return file;
        }
        if (fields.length < 6) {
            return null;
        }
        String owner = fields[0];
        long size = 0L;
        try {
            size = Long.parseLong(fields[1]);
        }
        catch (NumberFormatException ex) {
            log.warn("Failed to parse size: " + fields[1]);
        }
        String lastModifiedStr = fields[2] + " " + fields[3];
        Date lastModified = this.getLastModified(lastModifiedStr);
        boolean isDir = false;
        if (fields[4] == DIR || fields[4] == DDIR) {
            isDir = true;
        }
        int pos = raw.indexOf(fields[4]);
        String name = this.trimStart(raw.substring(pos += fields[4].length()));
        if (name.endsWith("/")) {
            isDir = true;
            name = name.substring(0, name.length() - 1);
        }
        FTPFile file = new FTPFile(raw, name, size, isDir, lastModified);
        file.setOwner(owner);
        return file;
    }

    private Date getLastModified(String lastModifiedStr) throws DateParseException {
        Date lastModified = null;
        if (this.formatIndex >= this.formats.length) {
            log.warn("Exhausted formats - failed to parse date");
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.add(5, 2);
        int prevIndex = this.formatIndex;
        int i = this.formatIndex;
        while (i < this.formats.length) {
            for (int j = 0; j < this.formats[i].length; ++j) {
                try {
                    SimpleDateFormat dateFormatter = new SimpleDateFormat(this.formats[this.formatIndex][j], this.locale);
                    lastModified = dateFormatter.parse(lastModifiedStr);
                    if (!lastModified.after(cal.getTime())) {
                        return lastModified;
                    }
                    log.debug("Swapping to alternate date format (found date in future)");
                    continue;
                }
                catch (ParseException ex) {
                    // empty catch block
                }
            }
            ++i;
            ++this.formatIndex;
        }
        if (this.formatIndex >= this.formats.length) {
            log.warn("Exhausted formats - failed to parse date");
            return null;
        }
        if (this.formatIndex > prevIndex) {
            throw new DateParseException(null);
        }
        return lastModified;
    }
}

