/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.collections.map;

import java.util.Map;
import java.util.Set;
import org.ujmp.core.collections.map.AbstractMap;
import org.ujmp.core.util.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Base64EncoderMap
extends AbstractMap<String, byte[]> {
    private static final long serialVersionUID = 5372707948791472795L;
    private final Map<String, String> map;

    public Base64EncoderMap(Map<String, String> map) {
        this.map = map;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public byte[] get(Object key) {
        try {
            String data = this.map.get(key);
            return data == null ? null : Base64.decode(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public byte[] put(String key, byte[] value) {
        try {
            byte[] oldValue = this.get(key);
            this.map.put(key, Base64.encodeBytes(value));
            return oldValue;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] remove(Object key) {
        byte[] oldValue = this.get(key);
        this.map.remove(key);
        return oldValue;
    }

    @Override
    public int size() {
        return this.map.size();
    }
}

