/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.collections.map;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ujmp.core.collections.map.AbstractMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoftHashMap<K, V>
extends AbstractMap<K, V> {
    private static final long serialVersionUID = 6784629567536455622L;
    private transient Map<K, SoftReference<V>> map = null;

    public SoftHashMap() {
    }

    public SoftHashMap(Map<? extends K, ? extends V> map) {
        this();
        this.putAll(map);
    }

    private Map<K, SoftReference<V>> getMap() {
        if (this.map == null) {
            this.map = new HashMap<K, SoftReference<V>>();
        }
        return this.map;
    }

    @Override
    public void clear() {
        this.getMap().clear();
    }

    @Override
    public V get(Object key) {
        SoftReference<V> v = this.getMap().get(key);
        return v == null ? null : (V)v.get();
    }

    @Override
    public Set<K> keySet() {
        return this.getMap().keySet();
    }

    @Override
    public V put(K key, V value) {
        while (true) {
            try {
                SoftReference<V> v = this.getMap().put(key, new SoftReference<V>(value));
                return v == null ? null : (V)v.get();
            }
            catch (OutOfMemoryError e) {
                this.getMap().remove(this.getMap().keySet().iterator().next());
                if (!this.getMap().isEmpty()) continue;
                throw new OutOfMemoryError("removing all entries from Map could not avoid OutOfMemoryError");
            }
            break;
        }
    }

    @Override
    public V remove(Object key) {
        SoftReference<V> v = this.getMap().remove(key);
        return v == null ? null : (V)v.get();
    }

    @Override
    public int size() {
        return this.getMap().size();
    }
}

