/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.core.api;

import edu.mit.broad.genome.TraceUtils;
import edu.mit.broad.xbench.core.api.FileManager;
import edu.mit.broad.xbench.core.api.ToolManager;
import edu.mit.broad.xbench.core.api.VdbManager;
import edu.mit.broad.xbench.core.api.WindowManager;
import java.awt.Dimension;
import java.awt.HeadlessException;
import xapps.api.frameworks.fiji.StatusBarAppender;

public class Application {
    private static Handler kAppHandler;
    public static Dimension DEFAULT_MODAL_WIDGET_RUNNER_DIALOG;

    private Application() {
    }

    public static boolean isHandlerSet() {
        return kAppHandler != null;
    }

    public static void registerHandler(Handler appHandler) {
        if (appHandler == null) {
            throw new IllegalArgumentException("Param appHandler cannot be null");
        }
        kAppHandler = appHandler;
    }

    private static void _check() {
        if (kAppHandler == null) {
            TraceUtils.showTrace();
            throw new IllegalStateException("No Application handler set yet: " + kAppHandler);
        }
    }

    public static ToolManager getToolManager() {
        Application._check();
        return kAppHandler.getToolManager();
    }

    public static FileManager getFileManager() {
        Application._check();
        return kAppHandler.getFileManager();
    }

    public static VdbManager getVdbManager() {
        Application._check();
        return kAppHandler.getVdbManager();
    }

    public static WindowManager getWindowManager() throws HeadlessException {
        Application._check();
        return kAppHandler.getWindowManager();
    }

    static {
        DEFAULT_MODAL_WIDGET_RUNNER_DIALOG = new Dimension(575, 500);
    }

    public static interface Handler {
        public StatusBarAppender getStatusBarAppender() throws HeadlessException;

        public ToolManager getToolManager();

        public FileManager getFileManager();

        public VdbManager getVdbManager();

        public WindowManager getWindowManager() throws HeadlessException;
    }
}

