/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.DirectoryListCallback;
import com.enterprisedt.net.ftp.EventListener;
import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileTransferClientInterface;
import com.enterprisedt.net.ftp.FileTransferInputStream;
import com.enterprisedt.net.ftp.FileTransferOutputStream;
import com.enterprisedt.net.ftp.WriteMode;
import com.enterprisedt.util.debug.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.Date;

public class FileTransferClientAdapter
implements FTPClientInterface,
EventListener {
    private static Logger log = Logger.getLogger("FileTransferClientAdapter");
    protected FileTransferClientInterface client;
    private boolean resume = false;
    private FTPProgressMonitor monitor;

    public FileTransferClientAdapter(FileTransferClientInterface client) {
        this.client = client;
    }

    public FileTransferClientInterface getFileTransferClient() {
        return this.client;
    }

    public void cancelResume() throws IOException, FTPException {
        this.resume = false;
    }

    public void cancelTransfer() {
        log.debug("Cancelling all transfers");
        this.client.cancelAllTransfers();
    }

    public void cdup() throws IOException, FTPException {
        this.client.changeToParentDirectory();
    }

    public void chdir(String dir) throws IOException, FTPException {
        this.client.changeDirectory(dir);
    }

    public void connect() throws IOException, FTPException {
        this.client.connect();
    }

    public boolean connected() {
        return this.client.isConnected();
    }

    public void delete(String remoteFile) throws IOException, FTPException {
        this.client.deleteFile(remoteFile);
    }

    public String[] dir() throws IOException, FTPException {
        return this.client.directoryNameList("", false);
    }

    public String[] dir(String dirname) throws IOException, FTPException {
        return this.client.directoryNameList(dirname, false);
    }

    public String[] dir(String dirname, boolean full) throws IOException, FTPException {
        return this.client.directoryNameList(dirname, full);
    }

    public FTPFile[] dirDetails(String dirname) throws IOException, FTPException, ParseException {
        return this.client.directoryList(dirname);
    }

    public void dirDetails(String dirname, DirectoryListCallback lister) throws IOException, FTPException, ParseException {
        this.client.directoryList(dirname, lister);
    }

    public boolean exists(String remoteFile) throws IOException, FTPException {
        return this.client.exists(remoteFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(String localPath, String remoteFile) throws IOException, FTPException {
        try {
            this.client.downloadFile(localPath, remoteFile, this.resume ? WriteMode.RESUME : WriteMode.OVERWRITE);
            Object var4_3 = null;
            this.resume = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.resume = false;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(OutputStream destStream, String remoteFile) throws IOException, FTPException {
        FileTransferInputStream str = null;
        try {
            str = this.client.downloadStream(remoteFile);
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = str.read(buf)) >= 0) {
                destStream.write(buf, 0, len);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            str.close();
            throw throwable;
        }
        str.close();
    }

    public byte[] get(String remoteFile) throws IOException, FTPException {
        return this.client.downloadByteArray(remoteFile);
    }

    public int getDeleteCount() {
        return this.client.getStatistics().getDeleteCount();
    }

    public boolean getDetectTransferMode() {
        return this.client.isDetectContentType();
    }

    public int getDownloadCount() {
        return this.client.getStatistics().getDownloadCount();
    }

    public String getId() {
        return null;
    }

    public long getMonitorInterval() {
        return this.client.getAdvancedSettings().getTransferNotifyInterval();
    }

    public String getRemoteHost() {
        return this.client.getRemoteHost();
    }

    public int getRemotePort() {
        return this.client.getRemotePort();
    }

    public int getTimeout() {
        return this.client.getTimeout();
    }

    public FTPTransferType getType() {
        return this.client.getContentType();
    }

    public int getUploadCount() {
        return this.client.getStatistics().getUploadCount();
    }

    public void keepAlive() throws IOException, FTPException {
    }

    public void mkdir(String dir) throws IOException, FTPException {
        this.client.createDirectory(dir);
    }

    public Date modtime(String remoteFile) throws IOException, FTPException {
        return this.client.getModifiedTime(remoteFile);
    }

    public void setModTime(String path, Date modTime) throws IOException, FTPException {
        this.client.setModifiedTime(path, modTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String put(String localPath, String remoteFile) throws IOException, FTPException {
        try {
            String string = this.client.uploadFile(localPath, remoteFile, this.resume ? WriteMode.RESUME : WriteMode.OVERWRITE);
            Object var5_4 = null;
            this.resume = false;
            return string;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.resume = false;
            throw throwable;
        }
    }

    public String put(InputStream srcStream, String remoteFile) throws IOException, FTPException {
        return this.put(srcStream, remoteFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String put(InputStream srcStream, String remoteFile, boolean append) throws IOException, FTPException {
        String string;
        block3: {
            FileTransferOutputStream str = null;
            try {
                str = this.client.uploadStream(remoteFile, append ? WriteMode.APPEND : WriteMode.OVERWRITE);
                byte[] buf = new byte[2048];
                int len = 0;
                while ((len = srcStream.read(buf)) >= 0) {
                    str.write(buf, 0, len);
                }
                string = str.getRemoteFile();
                Object var9_8 = null;
                if (str == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var9_9 = null;
                    if (str == null) break block4;
                    str.close();
                }
                throw throwable;
            }
            str.close();
        }
        return string;
    }

    public String put(byte[] bytes, String remoteFile) throws IOException, FTPException {
        return this.put(bytes, remoteFile, false);
    }

    public String put(byte[] bytes, String remoteFile, boolean append) throws IOException, FTPException {
        ByteArrayInputStream str = new ByteArrayInputStream(bytes);
        return this.put(str, remoteFile, append);
    }

    public String put(String localPath, String remoteFile, boolean append) throws IOException, FTPException {
        return this.client.uploadFile(localPath, remoteFile, WriteMode.APPEND);
    }

    public String pwd() throws IOException, FTPException {
        return this.client.getRemoteDirectory();
    }

    public void quit() throws IOException, FTPException {
        this.client.disconnect();
    }

    public void quitImmediately() throws IOException, FTPException {
        this.client.disconnect(true);
    }

    public void rename(String from, String to) throws IOException, FTPException {
        this.client.rename(from, to);
    }

    public void resetDeleteCount() {
        this.client.getStatistics().clear();
    }

    public void resetDownloadCount() {
        this.client.getStatistics().clear();
    }

    public void resetUploadCount() {
        this.client.getStatistics().clear();
    }

    public void resume() throws FTPException {
        this.resume = true;
    }

    public void resumeNextDownload(long offset) throws FTPException {
    }

    public void rmdir(String dir) throws IOException, FTPException {
        this.client.deleteDirectory(dir);
    }

    public void setDetectTransferMode(boolean detectTransferMode) {
        this.client.setDetectContentType(detectTransferMode);
    }

    public void setId(String id) {
    }

    public void setProgressMonitor(FTPProgressMonitor monitor, long interval) {
        this.monitor = monitor;
        this.client.setEventListener(this);
        this.client.getAdvancedSettings().setTransferNotifyInterval((int)interval);
    }

    public void setProgressMonitor(FTPProgressMonitor monitor) {
        this.monitor = monitor;
        this.client.setEventListener(this);
    }

    public void setRemoteHost(String remoteHost) throws IOException, FTPException {
        this.client.setRemoteHost(remoteHost);
    }

    public void setRemotePort(int remotePort) throws FTPException {
        this.client.setRemotePort(remotePort);
    }

    public void setTimeout(int timeout) throws IOException, FTPException {
        this.client.setTimeout(timeout);
    }

    public void setType(FTPTransferType type) throws IOException, FTPException {
        this.client.setContentType(type);
    }

    public long size(String remoteFile) throws IOException, FTPException {
        return this.client.getSize(remoteFile);
    }

    public String executeCommand(String command) throws FTPException, IOException {
        return this.client.executeCommand(command);
    }

    public String system() throws FTPException, IOException {
        return this.client.getSystemType();
    }

    public void setControlEncoding(String controlEncoding) throws FTPException {
        this.client.getAdvancedSettings().setControlEncoding(controlEncoding);
    }

    public void bytesTransferred(String connId, String remoteFile, long count) {
        log.debug("bytesTransferred(" + remoteFile + ": " + count + " bytes");
        if (this.monitor != null) {
            this.monitor.bytesTransferred(count);
        }
    }

    public void commandSent(String connId, String cmd) {
    }

    public void downloadCompleted(String connId, String remoteFilename) {
    }

    public void downloadStarted(String connId, String remoteFilename) {
    }

    public void replyReceived(String connId, String reply) {
    }

    public void uploadCompleted(String connId, String remoteFilename) {
    }

    public void uploadStarted(String connId, String remoteFilename) {
    }

    public int getNetworkBufferSize() {
        return 0;
    }

    public void setNetworkBufferSize(int networkBufferSize) {
    }

    public void setFileLockingEnabled(boolean lockingEnabled) {
        this.client.getAdvancedSettings().setFileLockingEnabled(lockingEnabled);
    }

    public boolean getFileLockingEnabled() {
        return this.client.getAdvancedSettings().getFileLockingEnabled();
    }
}

