/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.alg.DatasetBuilder;
import edu.mit.broad.genome.alg.RankedListGenerators;
import edu.mit.broad.genome.alg.distrib.RangeFactory;
import edu.mit.broad.genome.math.ColorSchemes;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.Range;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.StringMatrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.ColorDataset;
import edu.mit.broad.genome.objects.ColorDatasetImpl;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.ScoredDataset;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateFactory;
import edu.mit.broad.genome.objects.strucs.DatasetTemplate;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.chip.NullSymbolMode;
import edu.mit.broad.vdb.chip.NullSymbolModes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtools.api.param.BadParamException;

public class DatasetGenerators {
    private final Logger log = LoggerFactory.getLogger(DatasetGenerators.class);

    public ColorDataset createColorDataset(int numRanges, RankedList rl, ColorSchemes.ColorScheme cs) {
        Range[] ranges = RangeFactory.createRanges(numRanges, 0.0, rl.getSize());
        Vector v_full = rl.getScoresV(false);
        Matrix m = new Matrix(1, ranges.length);
        for (int c = 0; c < ranges.length; ++c) {
            m.setElement(0, c, (float)v_full.mean((int)ranges[c].getMin(), (int)ranges[c].getMax()));
        }
        return new ColorDatasetImpl(new DefaultDataset("foo", m), cs);
    }

    public CollapsedDataset collapse(Dataset origDs, Chip chip, boolean includeOnlySymbols, int collapse_gex_mode, String resultFileName) {
        if (origDs == null) {
            throw new IllegalArgumentException("Param ds cannot be null");
        }
        CollapsedDataset cds = new CollapsedDataset();
        cds.orig = origDs;
        Map<String, CollapseStruc> symbolCollapseStrucMap = cds.symbolCollapseStrucMap;
        this.populateCollapseStrucMap(origDs.getRowNames(), symbolCollapseStrucMap, chip, includeOnlySymbols, collapse_gex_mode);
        Matrix m = new Matrix(symbolCollapseStrucMap.size(), origDs.getNumCol());
        ArrayList<String> rowNames = new ArrayList<String>();
        ArrayList<String> rowDescs = new ArrayList<String>();
        int row = 0;
        for (String symbol : symbolCollapseStrucMap.keySet()) {
            CollapseStruc collapseStruc = symbolCollapseStrucMap.get(symbol);
            rowNames.add(collapseStruc.symbol);
            rowDescs.add(collapseStruc.title);
            String[] pss = collapseStruc.getProbes();
            if (pss.length == 1) {
                String ps = pss[0];
                m.setRow(row, origDs.getRow(ps));
            } else {
                Vector[] vss = origDs.getRows(new GeneSet("foo", "foo", pss));
                switch (collapse_gex_mode) {
                    case 0: {
                        m.setRow(row, XMath.maxVector(vss));
                        break;
                    }
                    case 1: {
                        m.setRow(row, XMath.medianVector(vss));
                        break;
                    }
                    case 2: {
                        m.setRow(row, XMath.meanVector(vss));
                        break;
                    }
                    case 3: {
                        m.setRow(row, XMath.sumVector(vss));
                        break;
                    }
                    case 4: {
                        m.setRow(row, XMath.abs_maxVector(vss));
                        break;
                    }
                    default: {
                        throw new BadParamException("Multiple rows mapped to the symbol ''" + collapseStruc.symbol + "'.  This is not allowed in Remap_only mode.", 1020);
                    }
                }
            }
            ++row;
        }
        String name = StringUtils.isNotBlank((CharSequence)resultFileName) ? resultFileName : origDs.getName() + this.getExtendedName(collapse_gex_mode) + "_to_symbols";
        this.log.info("Creating collapsed dataset {}, chosen mode {}", (Object)name, (Object)collapse_gex_mode);
        Annot annot = new Annot(new FeatureAnnot(name, rowNames, rowDescs, chip), origDs.getAnnot().getSampleAnnot_global());
        cds.symbolized = new DefaultDataset(name, m, rowNames, origDs.getColumnNames(), annot);
        if (cds.symbolized.getNumRow() <= 2000) {
            String warning = "Collapsed dataset results in " + cds.symbolized.getNumRow() + " features.  This may be too few for GSEA, which expects data for all expressed genes for a proper analysis.";
            this.log.warn(warning);
            cds.symbolized.addWarning(warning);
        }
        return cds;
    }

    public CollapsedRL collapse(RankedList origRL, Chip chip, boolean includeOnlySymbols, int collapse_gex_mode) {
        if (origRL == null) {
            throw new IllegalArgumentException("Param origRL cannot be null");
        }
        CollapsedRL collapsedRL = new CollapsedRL();
        collapsedRL.orig = origRL;
        Map<String, CollapseStruc> symbolCollapseStrucMap = collapsedRL.symbolCollapseStrucMap;
        this.populateCollapseStrucMap(origRL.getRankedNames(), symbolCollapseStrucMap, chip, includeOnlySymbols, collapse_gex_mode);
        Vector cl_scores = new Vector(symbolCollapseStrucMap.size());
        ArrayList<String> cl_rowNames = new ArrayList<String>();
        int row = 0;
        for (String symbol : symbolCollapseStrucMap.keySet()) {
            CollapseStruc collapseStruc = symbolCollapseStrucMap.get(symbol);
            cl_rowNames.add(collapseStruc.symbol);
            String[] pss = collapseStruc.getProbes();
            if (pss.length == 1) {
                String ps = pss[0];
                cl_scores.setElement(row, origRL.getScore(ps));
            } else {
                float[] fss = origRL.getScores(new GeneSet("foo", "foo", pss));
                switch (collapse_gex_mode) {
                    case 0: {
                        cl_scores.setElement(row, XMath.max(fss));
                        break;
                    }
                    case 1: {
                        cl_scores.setElement(row, XMath.median(fss));
                        break;
                    }
                    case 2: {
                        cl_scores.setElement(row, XMath.mean(fss));
                        break;
                    }
                    case 3: {
                        cl_scores.setElement(row, XMath.sum(fss));
                        break;
                    }
                    case 4: {
                        cl_scores.setElement(row, XMath.abs_max(fss));
                        break;
                    }
                    default: {
                        throw new BadParamException("Multiple rows mapped to the symbol ''" + collapseStruc.symbol + "'.  This is not allowed in Remap_only mode.", 1020);
                    }
                }
            }
            ++row;
        }
        if (cl_scores.getSize() == 0) {
            throw new BadParamException("The collapsed dataset was empty when used with chip:" + chip.getName(), 1005);
        }
        String newName = origRL.getName() + this.getExtendedName(collapse_gex_mode);
        RankedList sortedRL = RankedListGenerators.sortByVectorAndGetRankedList(cl_scores, SortMode.REAL, Order.DESCENDING, cl_rowNames).cloneShallowRL(newName);
        if (sortedRL.getSize() <= 2000) {
            String warning = "Collapsed ranked list results in " + sortedRL.getSize() + " features.  This may be too few for GSEA, which expects data for all expressed genes for a proper analysis.";
            this.log.warn(warning);
            sortedRL.addWarning(warning);
        }
        collapsedRL.symbolized = sortedRL;
        return collapsedRL;
    }

    private void populateCollapseStrucMap(List<String> origRowNames, Map<String, CollapseStruc> symbolCollapseStrucMap, Chip chip, boolean includeOnlySymbols, int collapse_gex_mode) {
        if (chip == null) {
            throw new IllegalArgumentException("Param chip cannot be null");
        }
        NullSymbolMode nm = includeOnlySymbols ? NullSymbolModes.OmitNulls : NullSymbolModes.ReplaceWithProbeId;
        for (String name : origRowNames) {
            String symbol = chip.getSymbol(name, nm);
            if (!StringUtils.isNotEmpty((CharSequence)symbol)) continue;
            CollapseStruc struc = symbolCollapseStrucMap.get(symbol);
            if (struc == null) {
                struc = new CollapseStruc(symbol, chip.getTitle(name, nm));
                symbolCollapseStrucMap.put(symbol, struc);
            }
            struc.add(name);
        }
    }

    private String getExtendedName(int collapse_gex_mode) {
        return collapse_gex_mode <= 4 ? "_collapsed" : "_remapped";
    }

    public DatasetTemplate extract(Dataset fullDs, Template template) {
        return DatasetGenerators.extract(fullDs, template, true);
    }

    public static synchronized DatasetTemplate extract(Dataset fullDs, Template origT, boolean verbose) {
        return TemplateFactory.extract(fullDs, origT, verbose);
    }

    private Dataset extractRows(String newName, Dataset ds, List<String> rowNames) {
        if (newName == null) {
            throw new IllegalArgumentException("Parameter newName cannot be null");
        }
        if (rowNames == null) {
            throw new IllegalArgumentException("Parameter probenames cannot be null");
        }
        if (ds == null) {
            throw new IllegalArgumentException("Parameter fullDs cannot be null");
        }
        DatasetBuilder builder = new DatasetBuilder(newName, ds.getColumnNames());
        int misscnt = 0;
        ArrayList<String> hitNames = new ArrayList<String>();
        for (int i = 0; i < rowNames.size(); ++i) {
            String probeName = rowNames.get(i);
            int index = ds.getRowIndex(probeName);
            if (index == -1) {
                ++misscnt;
                continue;
            }
            hitNames.add(probeName);
            builder.addRow(index, ds);
        }
        if (misscnt != 0) {
            this.log.warn("Not all probes had matches. Total probes:{} missing number:{} hits:{}", new Object[]{rowNames.size(), misscnt, hitNames.size()});
        }
        return builder.generate(ds.getAnnot());
    }

    public Dataset extractRows(Dataset fullDs, GeneSet gset) {
        if (gset == null) {
            throw new IllegalArgumentException("Parameter gset cannot be null");
        }
        if (fullDs == null) {
            throw new IllegalArgumentException("Parameter fullDs cannot be null");
        }
        String name = NamingConventions.generateName(fullDs, gset, true);
        return this.extractRows(name, fullDs, gset.getMembers());
    }

    public Dataset extractRows(Dataset ds, List<String> rowNames) {
        if (rowNames == null) {
            throw new IllegalArgumentException("Parameter names cannot be null");
        }
        if (ds == null) {
            throw new IllegalArgumentException("Parameter fullDs cannot be null");
        }
        String name = ds.getName() + "_nrows" + rowNames.size();
        return this.extractRows(name, ds, rowNames);
    }

    public Dataset extractRowsSorted(ScoredDataset fullSds, GeneSet gset) {
        if (gset == null) {
            throw new IllegalArgumentException("Parameter fset cannot be null");
        }
        if (fullSds == null) {
            throw new IllegalArgumentException("Parameter fullSds cannot be null");
        }
        GeneSet ofset = new GeneSet(gset, fullSds);
        String name = NamingConventions.generateName((Dataset)fullSds, gset, true);
        return this.extractRows(name, fullSds, ofset.getMembers());
    }

    private static StringDataframe makeEtiologySdf(Map<String, CollapseStruc> symbolCollapseStrucMap, List<String> names) {
        String[] colNames = new String[]{"# MATCHING PROBE SETS", "MATCHING PROBE SET(S)"};
        String[] rowNames = new String[names.size()];
        StringMatrix sm = new StringMatrix(rowNames.length, colNames.length);
        int r = 0;
        Iterator<String> iterator = names.iterator();
        while (iterator.hasNext()) {
            String name;
            rowNames[r] = name = iterator.next();
            CollapseStruc cs = symbolCollapseStrucMap.get(name);
            sm.setElement(r, 0, cs.getProbes().length);
            sm.setElement(r, 1, cs.getProbes());
            ++r;
        }
        return new StringDataframe("Symbol_to_probe_set_mapping_details", sm, rowNames, colNames);
    }

    public static class CollapseStruc {
        String symbol;
        String title;
        Set<String> probes;

        CollapseStruc(String symbol, String title) {
            this.symbol = symbol;
            this.title = title;
            this.probes = new HashSet<String>();
        }

        private void add(String ps) {
            this.probes.add(ps);
        }

        public String[] getProbes() {
            return this.probes.toArray(new String[this.probes.size()]);
        }

        public String toString() {
            return this.symbol;
        }

        public int hashCode() {
            return this.symbol.hashCode();
        }

        public boolean equals(Object obj) {
            return this.symbol.equals(obj);
        }

        public String getTitle() {
            return this.title;
        }
    }

    public static class CollapsedRL {
        public RankedList symbolized;
        public RankedList orig;
        public final Map<String, CollapseStruc> symbolCollapseStrucMap = new HashMap<String, CollapseStruc>();

        public StringDataframe makeEtiologySdf() {
            return DatasetGenerators.makeEtiologySdf(this.symbolCollapseStrucMap, this.symbolized.getRankedNames());
        }
    }

    public static class CollapsedDataset {
        public Dataset symbolized;
        public Dataset orig;
        final Map<String, CollapseStruc> symbolCollapseStrucMap = new HashMap<String, CollapseStruc>();

        public StringDataframe makeEtiologySdf() {
            return DatasetGenerators.makeEtiologySdf(this.symbolCollapseStrucMap, this.symbolized.getRowNames());
        }
    }
}

