/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.PreTemplate;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateImpl;
import edu.mit.broad.genome.objects.TemplateImplFromSampleNames;
import edu.mit.broad.genome.objects.strucs.DatasetTemplate;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateFactory
extends TemplateImpl {
    private static final Logger klog = LoggerFactory.getLogger(TemplateFactory.class);
    private static final String VS = "_versus_";

    private TemplateFactory() {
    }

    public static synchronized DatasetTemplate extract(Dataset fullDs, Template origT, boolean verbose) {
        if (fullDs == null) {
            throw new IllegalArgumentException("Parameter fullDs cannot be null");
        }
        if (origT == null) {
            throw new IllegalArgumentException("Parameter template cannot be null");
        }
        for (int i = 0; i < origT.getNumClasses(); ++i) {
            if (origT.getClass(i).getSize() != 0) continue;
            throw new IllegalArgumentException("In template: " + origT.getName() + " 0 members in class: " + origT.getClass(i).getName());
        }
        if (fullDs.getNumCol() == origT.getNumItems() && origT.isAscendingProfilePositions()) {
            if (verbose) {
                klog.info("Already a synched dataset-template -- NO extracting done");
            }
            return new DatasetTemplate(fullDs, origT);
        }
        if (verbose) {
            klog.info("Extracting ds: {} by template: {}", (Object)fullDs.getName(), (Object)origT.getName());
        }
        Matrix matrix = new Matrix(fullDs.getNumRow(), origT.getNumItems());
        ArrayList<String> colNames = new ArrayList<String>(origT.getNumItems());
        Template.Item[] newItems = new Template.Item[origT.getNumItems()];
        Template.Item[] orig_items = origT.getItemsOrderedByClassFirstAndThenProfilePos();
        for (int c = 0; c < orig_items.length; ++c) {
            int col2use = orig_items[c].getProfilePosition();
            matrix.setColumn(c, fullDs.getColumn(col2use));
            colNames.add(fullDs.getColumnName(col2use));
            newItems[c] = TemplateImpl.ItemImpl.createItem(orig_items[c].getId(), c);
        }
        String name = NamingConventions.generateName(fullDs, origT, true);
        DefaultDataset newds = new DefaultDataset(name, matrix, new ArrayList<String>(fullDs.getRowNames()), colNames, fullDs.getAnnot());
        newds.setProperty("extracted", "true");
        Template newt = TemplateFactory.createTemplate(origT.getName() + "_repos", newItems, origT.isContinuous());
        return new DatasetTemplate(newds, newt);
    }

    public static synchronized Template createTemplate(String name, Template.Item[] items, Template.Class[] classes, boolean continuous) {
        return TemplateFactory.createTemplate_ordered_assign(name, items, classes, continuous);
    }

    private static int _getColumnIndex(List colNames, String colName) {
        for (int c = 0; c < colNames.size(); ++c) {
            String cn = colNames.get(c).toString();
            if (!colName.equalsIgnoreCase(cn)) continue;
            return c;
        }
        return -1;
    }

    public static synchronized Template createCategoricalTemplate(String name, Dataset ds, String classAName, String[] classASampleNames, String classBName, String[] classBSampleNames) {
        return TemplateFactory.createCategoricalTemplate(name, ds.getColumnNames(), classAName, classASampleNames, classBName, classBSampleNames);
    }

    public static synchronized Template createCategoricalTemplate(String name, List all_col_names_ordered, String classAName, String[] classASampleNames, String classBName, String[] classBSampleNames) {
        if (classASampleNames.length == 0) {
            throw new IllegalArgumentException("Empty classASampleNames");
        }
        if (classBSampleNames.length == 0) {
            throw new IllegalArgumentException("Empty classBSampleNames");
        }
        GeneSet a = new GeneSet(classAName, classASampleNames);
        GeneSet b = new GeneSet(classBName, classBSampleNames);
        return TemplateFactory.createCategoricalTemplate(name, all_col_names_ordered, new GeneSet[]{a, b});
    }

    public static synchronized Template createCategoricalTemplate(String name, List all_col_names_ordered, GeneSet[] gsets_sample_names) {
        TemplateImpl template = new TemplateImpl(name);
        for (int i = 0; i < gsets_sample_names.length; ++i) {
            TemplateImpl.ClassImpl cl = new TemplateImpl.ClassImpl(gsets_sample_names[i].getName(true));
            template.add(cl);
            for (int r = 0; r < gsets_sample_names[i].getNumMembers(); ++r) {
                String sampleName = gsets_sample_names[i].getMember(r).toUpperCase();
                int pos = TemplateFactory._getColumnIndex(all_col_names_ordered, sampleName);
                if (pos == -1) {
                    throw new IllegalArgumentException("No such sample in ds: " + sampleName + " \n" + Printf.outs(all_col_names_ordered));
                }
                TemplateImpl.ItemImpl item = TemplateImpl.ItemImpl.createItem(gsets_sample_names[i].getName(true), pos);
                template.add(item);
                cl.add(item);
            }
        }
        template.setContinuous(false);
        template.setAux(false);
        template.makeImmutable();
        template.setSampleNamesFromDataset(true);
        return template;
    }

    private static synchronized Template createTemplate_ordered_assign(String name, Template.Item[] items, Template.Class[] classes, boolean continuous) {
        int i;
        if (items == null) {
            throw new IllegalArgumentException("Null items not allowed parameter");
        }
        if (classes == null) {
            throw new IllegalArgumentException("Null classes not allowed parameter");
        }
        TemplateImpl template = new TemplateImpl(name);
        for (i = 0; i < items.length; ++i) {
            template.add(items[i]);
        }
        for (i = 0; i < classes.length; ++i) {
            template.add(classes[i]);
        }
        template.assignItems2ClassInOrder();
        template.setContinuous(continuous);
        template.makeImmutable();
        return template;
    }

    public static synchronized Template createTemplate(String name, Template.Item[] items, boolean continuous) {
        if (items == null) {
            throw new IllegalArgumentException("Null items not allowed parameter");
        }
        ArrayList<String> classNames = new ArrayList<String>();
        Template.Item[] items_sorted = TemplateFactory.getProfilePositionsSorted(items);
        for (int i = 0; i < items_sorted.length; ++i) {
            String className = items_sorted[i].getId();
            if (classNames.contains(className)) continue;
            classNames.add(className);
        }
        Template.Class[] classes = new Template.Class[classNames.size()];
        for (int i = 0; i < classNames.size(); ++i) {
            classes[i] = new TemplateImpl.ClassImpl(classNames.get(i).toString());
        }
        return TemplateFactory.createTemplate_ordered_assign(name, items, classes, continuous);
    }

    public static synchronized Template createContinuousTemplate(String probeName, Vector profile) {
        TemplateImpl template = new TemplateImpl(probeName);
        for (int i = 0; i < profile.getSize(); ++i) {
            TemplateImpl.ClassImpl sept = new TemplateImpl.ClassImpl("class." + i);
            template.add(sept);
            TemplateImpl.ItemImpl item = TemplateImpl.ItemImpl.createItem(Float.toString(profile.getElement(i)), i);
            template.add(item);
            sept.add(item);
        }
        template.setContinuous(true);
        template.makeImmutable();
        return template;
    }

    public static synchronized Template createContinuousTemplate(String probe_name, Dataset ds) {
        int rindex = ds.getRowIndex(probe_name);
        if (rindex == -1) {
            throw new IllegalArgumentException("No data in Dataset: " + ds.getName() + " for probe: " + probe_name);
        }
        Vector vector = ds.getRow(rindex);
        return TemplateFactory.createContinuousTemplate(probe_name, vector);
    }

    public static Template[] extractAllPossibleTemplates(Template origT, boolean includeOrigT) throws Exception {
        if (origT == null) {
            throw new IllegalArgumentException("Parameter origT cannot be null");
        }
        ArrayList<Template> options = new ArrayList<Template>();
        if (includeOrigT) {
            options.add(origT);
        }
        if (!(origT instanceof PreTemplate)) {
            if (origT instanceof TemplateImplFromSampleNames) {
                Template straight = TemplateFactory.extractForwardBiphasicTemplate(origT);
                options.add(straight);
                Template rev = TemplateFactory.createReversedBiphasicTemplate(origT);
                options.add(rev);
            } else if (!origT.isContinuous()) {
                if (origT.getNumClasses() > 2) {
                    Template[] all = TemplateFactory.extractAll2ClassTemplates(origT, false);
                    for (int i = 0; i < all.length; ++i) {
                        options.add(all[i]);
                    }
                }
                if (origT.getNumClasses() == 2) {
                    Template straight = TemplateFactory.extractForwardBiphasicTemplate(origT);
                    options.add(straight);
                    Template rev = TemplateFactory.createReversedBiphasicTemplate(origT);
                    options.add(rev);
                }
                if (!origT.isAux() && origT.getNumClasses() > 1) {
                    Template[] unis = TemplateFactory.extractAllUniphasicTemplates(origT);
                    for (int i = 0; i < unis.length; ++i) {
                        options.add(unis[i]);
                    }
                }
            }
        }
        return options.toArray(new Template[options.size()]);
    }

    public static Template[] extractAll2ClassTemplates(Template parentMultiClassTemplate, boolean onlyForwardOvas) {
        ArrayList<Template> templates = new ArrayList<Template>();
        if (parentMultiClassTemplate.getNumClasses() == 2) {
            templates.add(parentMultiClassTemplate);
            templates.add(TemplateFactory.createReversedBiphasicTemplate(parentMultiClassTemplate));
            return templates.toArray(new Template[templates.size()]);
        }
        Template[] ovas = TemplateFactory.extractAllOvaTemplates(parentMultiClassTemplate, onlyForwardOvas);
        for (int i = 0; i < ovas.length; ++i) {
            templates.add(ovas[i]);
        }
        Template[] allpairs = TemplateFactory.extractAllPairsTemplates(parentMultiClassTemplate);
        for (int i = 0; i < allpairs.length; ++i) {
            templates.add(allpairs[i]);
        }
        return templates.toArray(new Template[templates.size()]);
    }

    public static synchronized Template[] extractAllPairsTemplates(Template parentMultiClassTemplate) {
        if (parentMultiClassTemplate.getNumClasses() < 2) {
            throw new IllegalArgumentException("At least 3 Template classes needed to do ALL_PAIRS");
        }
        if (parentMultiClassTemplate.isContinuous()) {
            throw new IllegalArgumentException("Cannot work on continuous Template: " + parentMultiClassTemplate.getName());
        }
        ArrayList<Template.Class[]> templatePairs = new ArrayList<Template.Class[]>();
        for (int i = 0; i < parentMultiClassTemplate.getNumClasses(); ++i) {
            Template.Class a = parentMultiClassTemplate.getClass(i);
            for (int j = 0; j < parentMultiClassTemplate.getNumClasses(); ++j) {
                if (i == j) continue;
                Template.Class b = parentMultiClassTemplate.getClass(j);
                templatePairs.add(new Template.Class[]{a, b});
            }
        }
        ArrayList<TemplateImpl> templates = new ArrayList<TemplateImpl>(templatePairs.size());
        for (int t = 0; t < templatePairs.size(); ++t) {
            Template.Item newItem;
            Template.Item orig;
            int i;
            Template.Class[] pair = (Template.Class[])templatePairs.get(t);
            String newtName = parentMultiClassTemplate.getName() + "#" + pair[0].getName() + VS + pair[1].getName();
            TemplateImpl newT = new TemplateImpl(newtName);
            TemplateImpl.ClassImpl newClassA = new TemplateImpl.ClassImpl(pair[0].getName());
            TemplateImpl.ClassImpl newClassB = new TemplateImpl.ClassImpl(pair[1].getName());
            newT.add(newClassA);
            newT.add(newClassB);
            for (i = 0; i < pair[0].getSize(); ++i) {
                orig = pair[0].getItem(i);
                newItem = orig.cloneDeep();
                newClassA.add(newItem);
                newT.add(newItem);
            }
            for (i = 0; i < pair[1].getSize(); ++i) {
                orig = pair[1].getItem(i);
                newItem = orig.cloneDeep();
                newClassB.add(newItem);
                newT.add(newItem);
            }
            newT.setContinuous(false);
            newT.makeImmutable();
            templates.add(newT);
        }
        return templates.toArray(new Template[templates.size()]);
    }

    public static synchronized Template[] extractAllOvaTemplates(Template multiClassTemplate, boolean onlyForward) {
        if (multiClassTemplate.getNumClasses() <= 2) {
            throw new IllegalArgumentException("At least 3 Template classes needed to make a set of ova templates but found: " + multiClassTemplate.getNumClasses() + "\n" + multiClassTemplate.getAsString(false));
        }
        ArrayList<Template> ovas = new ArrayList<Template>();
        for (int c = 0; c < multiClassTemplate.getNumClasses(); ++c) {
            Template.Class one = multiClassTemplate.getClass(c);
            Template ova = TemplateFactory.extractOvaTemplate(multiClassTemplate, one);
            ovas.add(ova);
            if (onlyForward) continue;
            String rname = multiClassTemplate.getName() + "#REST_versus_" + one.getName();
            Template rova = TemplateFactory._createReversedBiphasicTemplate(rname, ova);
            ovas.add(rova);
        }
        return ovas.toArray(new Template[ovas.size()]);
    }

    public static synchronized Template extractOvaTemplate(Template parentMultiClassTemplate, Template.Class theOneClass) {
        if (!parentMultiClassTemplate.isMemberClass(theOneClass)) {
            throw new IllegalArgumentException("Specified theOneClass: " + theOneClass.getName() + " is not a member of parentMultiClassTemplate: " + parentMultiClassTemplate.getName());
        }
        if (parentMultiClassTemplate.getNumClasses() <= 2) {
            throw new IllegalArgumentException("Need 3 or more classes to do a ova. Found: " + parentMultiClassTemplate.getNumClasses());
        }
        if (parentMultiClassTemplate.isContinuous()) {
            throw new IllegalArgumentException("Cannot work on continuous Template: " + parentMultiClassTemplate.getName());
        }
        String newtName = parentMultiClassTemplate.getName() + "#" + theOneClass.getName() + "_versus_REST";
        TemplateImpl newT = new TemplateImpl(newtName);
        TemplateImpl.ClassImpl clonedTheOneClass = new TemplateImpl.ClassImpl(theOneClass.getName());
        newT.add(clonedTheOneClass);
        int index = parentMultiClassTemplate.getClassIndex(theOneClass);
        TemplateImpl.ClassImpl restClass = new TemplateImpl.ClassImpl("REST");
        newT.add(restClass);
        for (int c = 0; c < theOneClass.getSize(); ++c) {
            TemplateImpl.ItemImpl item = TemplateImpl.ItemImpl.createItem(theOneClass.getName(), theOneClass.getItem(c).getProfilePosition());
            newT.add(item);
            clonedTheOneClass.add(item);
        }
        for (int i = 0; i < parentMultiClassTemplate.getNumClasses(); ++i) {
            Template.Class cl = parentMultiClassTemplate.getClass(i);
            if (i == index) continue;
            for (int c = 0; c < cl.getSize(); ++c) {
                TemplateImpl.ItemImpl item = TemplateImpl.ItemImpl.createItem("REST", cl.getItem(c).getProfilePosition());
                newT.add(item);
                restClass.add(item);
            }
        }
        newT.setContinuous(false);
        newT.makeImmutable();
        return newT;
    }

    public static synchronized Template extractForwardBiphasicTemplate(Template origTemplate) {
        if (origTemplate.getNumClasses() != 2) {
            throw new IllegalArgumentException("Cannot straight template as its not biphasic. # classes: " + origTemplate.getNumClasses() + " " + origTemplate.getName());
        }
        String newName = origTemplate.getName() + "#" + origTemplate.getClassName(0) + VS + origTemplate.getClassName(1);
        Template newTemplate = origTemplate.cloneDeep(newName);
        newTemplate.makeImmutable();
        return newTemplate;
    }

    public static synchronized Template createReversedBiphasicTemplate(Template origTemplate) {
        return TemplateFactory._createReversedBiphasicTemplate(origTemplate.getName() + "#" + origTemplate.getClassName(1) + VS + origTemplate.getClassName(0), origTemplate);
    }

    private static synchronized Template _createReversedBiphasicTemplate(String name, Template origTemplate) {
        if (origTemplate.getNumClasses() != 2) {
            throw new IllegalArgumentException("Cannot reverse template as its not biphasic. # classes: " + origTemplate.getNumClasses() + " " + origTemplate.getName());
        }
        if (origTemplate instanceof TemplateImplFromSampleNames) {
            return ((TemplateImplFromSampleNames)origTemplate).cloneDeepReversed(name);
        }
        TemplateImpl newT = new TemplateImpl(name);
        TemplateImpl.ClassImpl newClassA = new TemplateImpl.ClassImpl(origTemplate.getClass(1).getName());
        for (int i = 0; i < origTemplate.getClass(1).getSize(); ++i) {
            Template.Item newItem = origTemplate.getClass(1).getItem(i);
            newClassA.add(newItem.cloneDeep());
            newT.add(newItem);
        }
        TemplateImpl.ClassImpl newClassB = new TemplateImpl.ClassImpl(origTemplate.getClassName(0));
        for (int i = 0; i < origTemplate.getClass(0).getSize(); ++i) {
            Template.Item newItem = origTemplate.getClass(0).getItem(i);
            newClassB.add(newItem.cloneDeep());
            newT.add(newItem);
        }
        newT.add(newClassA);
        newT.add(newClassB);
        newT.setContinuous(false);
        newT.makeImmutable();
        return newT;
    }

    public static synchronized Template extractUniphasicTemplate(Template fullTemplate, Template.Class cl) {
        if (fullTemplate.isAux()) {
            throw new IllegalArgumentException("Cannot make uniphasic from aux templates: " + fullTemplate.getName());
        }
        TemplateImpl template = new TemplateImpl(fullTemplate.getName() + "#" + cl.getName());
        TemplateImpl.ClassImpl onlyClass = new TemplateImpl.ClassImpl(cl.getName());
        template.add(onlyClass);
        for (int i = 0; i < cl.getSize(); ++i) {
            Template.Item origItem = cl.getItem(i);
            Template.Item item = origItem.cloneDeep();
            template.add(item);
            onlyClass.add(item);
        }
        template.setContinuous(false);
        template.setAux(true);
        template.makeImmutable();
        return template;
    }

    public static synchronized Template[] extractAllUniphasicTemplates(Template fullTemplate) {
        Template[] unis = new Template[fullTemplate.getNumClasses()];
        for (int i = 0; i < fullTemplate.getNumClasses(); ++i) {
            unis[i] = TemplateFactory.extractUniphasicTemplate(fullTemplate, fullTemplate.getClass(i));
        }
        return unis;
    }
}

