/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.swing.windows;

import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.core.api.DialogDescriptor;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class GListWindow {
    private final JList jlOptions = new JList();
    private DefaultListModel fModel = new DefaultListModel();
    private int fSelectionMode = 0;
    private Action fHelp_action_opt;
    private JComponent fNorthComponent;

    public GListWindow(Action help_action_opt) {
        this.init(help_action_opt);
    }

    private void init(Action help_action_opt) {
        this.fHelp_action_opt = help_action_opt;
    }

    public JList getJList() {
        return this.jlOptions;
    }

    public Object[] show(Object[] options, Object[] selectedOnes) {
        this.fillModel(options);
        return this._show(selectedOnes);
    }

    public Object[] show() {
        return this._show(new Object[0]);
    }

    private Object[] _show(Object[] selectedOnes) {
        this.jlOptions.setModel(this.fModel);
        this.jlOptions.setSelectionMode(this.fSelectionMode);
        GuiHelper.List2.setSelected(selectedOnes, this.jlOptions, this.fModel);
        return this._just_show();
    }

    private Object[] _just_show() {
        DialogDescriptor desc;
        String text = "Select an option";
        if (this.fSelectionMode == 2) {
            text = "Select one or more option(s)";
        }
        if (this.fNorthComponent == null) {
            desc = Application.getWindowManager().createDialogDescriptor(text, new JScrollPane(this.jlOptions), this.fHelp_action_opt);
        } else {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)this.fNorthComponent, "North");
            panel.add((Component)new JScrollPane(this.jlOptions), "Center");
            desc = Application.getWindowManager().createDialogDescriptor(text, panel, this.fHelp_action_opt);
        }
        desc.enableDoubleClickableJList(this.jlOptions);
        int res = desc.show();
        if (res == 2) {
            return null;
        }
        return this.jlOptions.getSelectedValues();
    }

    private void fillModel(Object[] options) {
        this.fModel = new DefaultListModel();
        for (int i = 0; i < options.length; ++i) {
            this.fModel.addElement(options[i]);
        }
    }

    public void setListSelectionMode(int mode) {
        this.fSelectionMode = mode;
        this.jlOptions.setSelectionMode(this.fSelectionMode);
    }
}

