/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.explorer.objmgr;

import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.DataFormat;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.utils.ClassUtils;
import java.awt.Component;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class ObjectTreeRenderer
extends DefaultTreeCellRenderer {
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        Icon icon = null;
        Object obj = value;
        if (value instanceof DefaultMutableTreeNode) {
            obj = ((DefaultMutableTreeNode)value).getUserObject();
        }
        if (!(obj instanceof String)) {
            icon = DataFormat.getIcon(obj);
        }
        String txt = null;
        Object desc = null;
        if (obj != null) {
            if (obj instanceof PersistentObject) {
                PersistentObject pob = (PersistentObject)obj;
                if (pob.getQuickInfo() != null) {
                    StringBuffer buf = new StringBuffer("<html><body>").append(pob.getName());
                    buf.append("<font color=gray> [").append(pob.getQuickInfo()).append(']').append("</font></html></body>");
                    txt = buf.toString();
                } else {
                    txt = pob.getName();
                }
                File f = ParserFactory.getCache().getSourceFile(obj);
                desc = f != null ? f.getAbsolutePath() : "Unknown path for pob: " + obj;
            } else {
                txt = obj.toString();
                if ((txt = ClassUtils.packageName2ClassName(txt)).equals("FSet")) {
                    txt = "<html><body>GeneSet <font color=gray>[grp]</font></body></html>";
                } else if (txt.equalsIgnoreCase("GeneSet")) {
                    txt = "Gene sets";
                } else if (txt.equalsIgnoreCase("ErrorPob")) {
                    txt = "Errors";
                } else if (txt.equalsIgnoreCase("GeneSetMatrix")) {
                    txt = "Gene set databases";
                } else if (txt.equalsIgnoreCase("SampleAnnot")) {
                    txt = "Sample annotations";
                } else if (txt.equalsIgnoreCase("GenesOfInterest")) {
                    txt = "Genes of interest";
                } else if (txt.equalsIgnoreCase("Dataset")) {
                    txt = "Datasets";
                } else if (txt.equalsIgnoreCase("EnrichmentDb")) {
                    txt = "Enrichment results";
                } else if (txt.equalsIgnoreCase("Template")) {
                    txt = "Phenotypes";
                } else if (txt.equalsIgnoreCase("RankedList")) {
                    txt = "RankedGeneList";
                }
            }
        }
        if (txt != null) {
            this.setText(txt);
        }
        if (desc != null) {
            this.setToolTipText((String)desc);
            this.setOpaque(false);
        }
        if (icon != null) {
            this.setIcon(icon);
        }
        return this;
    }
}

