/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.elasticsearch;

import java.io.IOException;
import java.util.Set;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Base64;
import org.ujmp.core.mapmatrix.AbstractMapMatrix;
import org.ujmp.core.mapmatrix.DefaultMapMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.elasticsearch.ElasticsearchIndex;
import org.ujmp.elasticsearch.ElasticsearchSample;
import org.ujmp.elasticsearch.ElasticsearchUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElasticsearchDataMap
extends AbstractMapMatrix<String, byte[]> {
    private static final long serialVersionUID = -75029573088286998L;
    public static final String ID = "_id";
    public static final String DATA = "data";
    public static final String LENGTH = "length";
    private final ElasticsearchIndex index;

    public ElasticsearchDataMap(String hostname, String index, String type) {
        this(hostname, 9300, index, type);
    }

    public ElasticsearchDataMap(String hostname, int port, String index, String type) {
        this((Client)ElasticsearchUtil.createTransportClient(hostname, port), index, type);
    }

    public ElasticsearchDataMap(Client client, String index, String type) {
        this.index = new ElasticsearchIndex(client, index, type);
    }

    @Override
    public int size() {
        return this.index.size();
    }

    @Override
    public byte[] get(Object key) {
        byte[] bytes;
        ElasticsearchSample s = this.index.get(key);
        if (s == null) {
            return null;
        }
        Object data = s.get(DATA);
        try {
            bytes = Base64.decode((byte[])String.valueOf(data).getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bytes;
    }

    @Override
    public Set<String> keySet() {
        return this.index.keySet();
    }

    @Override
    protected void clearMap() {
        this.index.clear();
    }

    @Override
    protected byte[] removeFromMap(Object key) {
        this.index.remove(key);
        return null;
    }

    public void addData(byte[] data) {
        if (data == null) {
            return;
        }
        String id = MathUtil.md5(data);
        this.put(id, data);
    }

    public void removeData(byte[] data) {
        if (data != null) {
            String id = MathUtil.md5(data);
            this.remove(id);
        }
    }

    @Override
    protected byte[] putIntoMap(String key, byte[] value) {
        if (value == null) {
            return (byte[])this.remove(key);
        }
        if (!this.index.containsKey(key)) {
            DefaultMapMatrix<String, Object> map = new DefaultMapMatrix<String, Object>();
            map.put(ID, key);
            map.put(DATA, value);
            map.put(LENGTH, value.length);
            this.index.put(map);
        }
        return null;
    }
}

