/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.elasticsearch;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.print.attribute.UnmodifiableSetException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.ujmp.elasticsearch.ElasticsearchIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KeyIterator
implements Iterator<String> {
    private final ElasticsearchIndex index;
    private Iterator<SearchHit> iterator;
    private SearchResponse scrollResp;

    public KeyIterator(ElasticsearchIndex index) {
        this.index = index;
        MatchAllQueryBuilder query = QueryBuilders.matchAllQuery();
        this.scrollResp = (SearchResponse)index.getClient().prepareSearch(new String[]{index.getIndex()}).setTypes(new String[]{index.getType()}).addFields(new String[0]).setSearchType(SearchType.SCAN).setScroll(new TimeValue(600000L)).setQuery((QueryBuilder)query).setSize(1000).execute().actionGet();
        this.scrollResp = (SearchResponse)index.getClient().prepareSearchScroll(this.scrollResp.getScrollId()).setScroll(new TimeValue(600000L)).execute().actionGet();
        this.iterator = this.scrollResp.getHits().iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.iterator != null && !this.iterator.hasNext()) {
            this.scrollResp = (SearchResponse)this.index.getClient().prepareSearchScroll(this.scrollResp.getScrollId()).setScroll(new TimeValue(600000L)).execute().actionGet();
            this.iterator = this.scrollResp.getHits().getHits().length == 0 ? null : this.scrollResp.getHits().iterator();
        }
        return this.iterator != null && this.iterator.hasNext();
    }

    @Override
    public String next() {
        if (this.iterator != null) {
            SearchHit hit = this.iterator.next();
            return hit.getId();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnmodifiableSetException();
    }
}

