/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jdbc.autoclose;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import org.ujmp.core.util.UJMPTimer;
import org.ujmp.jdbc.autoclose.AutoCloseCallableStatement;
import org.ujmp.jdbc.autoclose.AutoClosePreparedStatement;
import org.ujmp.jdbc.autoclose.AutoCloseStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCloseConnection
implements Connection {
    public static final int DEFAULTMAXIDLETIME = 3600000;
    public static final int DEFAULTCHECKINTERVAL = 1000;
    private final Connection connection;
    private final TimerTask timerTask;
    private final UJMPTimer timer;
    private long lastAccessTime = System.currentTimeMillis();

    public AutoCloseConnection(Connection c) {
        this(c, 3600000);
    }

    public AutoCloseConnection(Connection c, int maxIdleTime) {
        this(c, maxIdleTime, 1000L);
    }

    public AutoCloseConnection(Connection c, final int maxIdleTime, long checkInterval) {
        this.connection = c;
        this.timerTask = new TimerTask(){

            public void run() {
                try {
                    long idleTime;
                    if (AutoCloseConnection.this.connection != null && !AutoCloseConnection.this.connection.isClosed() && (idleTime = System.currentTimeMillis() - AutoCloseConnection.this.lastAccessTime) >= (long)maxIdleTime) {
                        System.out.println("closing connection after " + idleTime + " ms");
                        AutoCloseConnection.this.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.timer = UJMPTimer.newInstance("AutoCloseConnection");
        this.timer.schedule(this.timerTask, checkInterval, checkInterval);
    }

    @Override
    public final synchronized <T> T unwrap(Class<T> iface) throws SQLException {
        this.resetTimer();
        return this.connection.unwrap(iface);
    }

    public final void resetTimer() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    @Override
    public final synchronized boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.resetTimer();
        return this.connection.isWrapperFor(iface);
    }

    @Override
    public final synchronized Statement createStatement() throws SQLException {
        this.resetTimer();
        return new AutoCloseStatement(this, this.connection.createStatement());
    }

    @Override
    public final synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        this.resetTimer();
        return new AutoClosePreparedStatement(this, this.connection.prepareStatement(sql));
    }

    @Override
    public final synchronized CallableStatement prepareCall(String sql) throws SQLException {
        this.resetTimer();
        return new AutoCloseCallableStatement(this, this.connection.prepareCall(sql));
    }

    @Override
    public final synchronized String nativeSQL(String sql) throws SQLException {
        this.resetTimer();
        return this.connection.nativeSQL(sql);
    }

    @Override
    public final synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        this.resetTimer();
        this.connection.setAutoCommit(autoCommit);
    }

    @Override
    public final synchronized boolean getAutoCommit() throws SQLException {
        this.resetTimer();
        return this.connection.getAutoCommit();
    }

    @Override
    public final synchronized void commit() throws SQLException {
        this.resetTimer();
        this.connection.commit();
    }

    @Override
    public final synchronized void rollback() throws SQLException {
        this.resetTimer();
        this.connection.rollback();
    }

    @Override
    public final synchronized void close() throws SQLException {
        this.timer.cancel();
        this.timer.purge();
        this.connection.close();
    }

    @Override
    public final synchronized boolean isClosed() throws SQLException {
        this.resetTimer();
        return this.connection.isClosed();
    }

    @Override
    public final synchronized DatabaseMetaData getMetaData() throws SQLException {
        this.resetTimer();
        return this.connection.getMetaData();
    }

    @Override
    public final synchronized void setReadOnly(boolean readOnly) throws SQLException {
        this.resetTimer();
        this.connection.setReadOnly(readOnly);
    }

    @Override
    public final synchronized boolean isReadOnly() throws SQLException {
        this.resetTimer();
        return this.connection.isReadOnly();
    }

    @Override
    public final synchronized void setCatalog(String catalog) throws SQLException {
        this.resetTimer();
        this.connection.setCatalog(catalog);
    }

    @Override
    public final synchronized String getCatalog() throws SQLException {
        this.resetTimer();
        return this.connection.getCatalog();
    }

    @Override
    public final synchronized void setTransactionIsolation(int level) throws SQLException {
        this.resetTimer();
        this.connection.setTransactionIsolation(level);
    }

    @Override
    public final synchronized int getTransactionIsolation() throws SQLException {
        this.resetTimer();
        return this.connection.getTransactionIsolation();
    }

    @Override
    public final synchronized SQLWarning getWarnings() throws SQLException {
        this.resetTimer();
        return this.connection.getWarnings();
    }

    @Override
    public final synchronized void clearWarnings() throws SQLException {
        this.resetTimer();
        this.connection.clearWarnings();
    }

    @Override
    public final synchronized Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.resetTimer();
        return new AutoCloseStatement(this, this.connection.createStatement(resultSetType, resultSetConcurrency));
    }

    @Override
    public final synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.resetTimer();
        return new AutoClosePreparedStatement(this, this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency));
    }

    @Override
    public final synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.resetTimer();
        return new AutoCloseCallableStatement(this, this.connection.prepareCall(sql, resultSetType, resultSetConcurrency));
    }

    @Override
    public final synchronized Map<String, Class<?>> getTypeMap() throws SQLException {
        this.resetTimer();
        return this.connection.getTypeMap();
    }

    @Override
    public final synchronized void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.resetTimer();
        this.connection.setTypeMap(map);
    }

    @Override
    public final synchronized void setHoldability(int holdability) throws SQLException {
        this.resetTimer();
        this.connection.setHoldability(holdability);
    }

    @Override
    public final synchronized int getHoldability() throws SQLException {
        this.resetTimer();
        return this.connection.getHoldability();
    }

    @Override
    public final synchronized Savepoint setSavepoint() throws SQLException {
        this.resetTimer();
        return this.connection.setSavepoint();
    }

    @Override
    public final synchronized Savepoint setSavepoint(String name) throws SQLException {
        this.resetTimer();
        return this.connection.setSavepoint(name);
    }

    @Override
    public final synchronized void rollback(Savepoint savepoint) throws SQLException {
        this.resetTimer();
        this.connection.rollback(savepoint);
    }

    @Override
    public final synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.resetTimer();
        this.connection.releaseSavepoint(savepoint);
    }

    @Override
    public final synchronized Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.resetTimer();
        return new AutoCloseStatement(this, this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public final synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.resetTimer();
        return new AutoClosePreparedStatement(this, this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public final synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.resetTimer();
        return new AutoCloseCallableStatement(this, this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public final synchronized PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.resetTimer();
        return new AutoClosePreparedStatement(this, this.connection.prepareStatement(sql, autoGeneratedKeys));
    }

    @Override
    public final synchronized PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.resetTimer();
        return new AutoClosePreparedStatement(this, this.connection.prepareStatement(sql, columnIndexes));
    }

    @Override
    public final synchronized PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.resetTimer();
        return new AutoClosePreparedStatement(this, this.connection.prepareStatement(sql, columnNames));
    }

    @Override
    public final synchronized Clob createClob() throws SQLException {
        this.resetTimer();
        return this.connection.createClob();
    }

    @Override
    public final synchronized Blob createBlob() throws SQLException {
        this.resetTimer();
        return this.connection.createBlob();
    }

    @Override
    public final synchronized NClob createNClob() throws SQLException {
        this.resetTimer();
        return this.connection.createNClob();
    }

    @Override
    public final synchronized SQLXML createSQLXML() throws SQLException {
        this.resetTimer();
        return this.connection.createSQLXML();
    }

    @Override
    public final synchronized boolean isValid(int timeout) throws SQLException {
        this.resetTimer();
        return this.connection.isValid(timeout);
    }

    @Override
    public final synchronized void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.resetTimer();
        this.connection.setClientInfo(name, value);
    }

    @Override
    public final synchronized void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.resetTimer();
        this.connection.setClientInfo(properties);
    }

    @Override
    public final synchronized String getClientInfo(String name) throws SQLException {
        this.resetTimer();
        return this.connection.getClientInfo(name);
    }

    @Override
    public final synchronized Properties getClientInfo() throws SQLException {
        this.resetTimer();
        return this.connection.getClientInfo();
    }

    @Override
    public final synchronized Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.resetTimer();
        return this.connection.createArrayOf(typeName, elements);
    }

    @Override
    public final synchronized Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.resetTimer();
        return this.connection.createStruct(typeName, attributes);
    }

    @Override
    public final synchronized void setSchema(String schema) throws SQLException {
        this.resetTimer();
        this.connection.setSchema(schema);
    }

    @Override
    public final synchronized String getSchema() throws SQLException {
        this.resetTimer();
        return this.connection.getSchema();
    }

    @Override
    public final synchronized void abort(Executor executor) throws SQLException {
        this.resetTimer();
        this.connection.abort(executor);
    }

    @Override
    public final synchronized void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.resetTimer();
        this.connection.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public final synchronized int getNetworkTimeout() throws SQLException {
        this.resetTimer();
        return this.connection.getNetworkTimeout();
    }

    public String toString() {
        this.resetTimer();
        return this.connection.toString();
    }

    public boolean equals(Object obj) {
        this.resetTimer();
        return this.connection.equals(obj);
    }

    public int hashCode() {
        this.resetTimer();
        return this.connection.hashCode();
    }
}

