/* $Id: PDB_seq_id.cpp 663096 2023-02-13 13:06:39Z ivanov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the ASN data definition file
 *   'seqloc.asn'.
 */

#include <ncbi_pch.hpp>
#include <objects/seqloc/PDB_seq_id.hpp>
#include <objects/seqloc/PDB_mol_id.hpp>

BEGIN_NCBI_SCOPE
BEGIN_objects_SCOPE // namespace ncbi::objects::


// destructor
CPDB_seq_id::~CPDB_seq_id(void)
{
    return;
}


// comparison function
bool CPDB_seq_id::Match(const CPDB_seq_id& psip2) const
{
    if (IsSetChain() && psip2.IsSetChain()) {
        if (GetChain() != psip2.GetChain()) {
            return false;
        }
    }
    if (IsSetChain_id() && psip2.IsSetChain_id()) {
        if ( PCase().Compare(GetChain_id(), psip2.GetChain_id())) {
            return false;
        }
    }
    return
        PCase().Equals(GetMol(), psip2.GetMol());
}


static string s_GetEffectiveChain_id(const CPDB_seq_id& id)
{
    if ( id.IsSetChain_id() ) {
        return id.GetChain_id();
    }
    if ( id.IsSetChain() ) {
        return string(1, char(id.GetChain()));
    }
    return string();
}

int CPDB_seq_id::Compare(const CPDB_seq_id& psip2) const
{
    if ( int diff = PNocase().Compare(GetMol(), psip2.GetMol()) ) {
        return diff;
    }
    // optimization to avoid creation of temporary strings if both chain-id are set
    if ( IsSetChain_id() && psip2.IsSetChain_id() ) {
        return PCase().Compare(GetChain_id(), psip2.GetChain_id());
    }
    return PCase().Compare(s_GetEffectiveChain_id(*this), s_GetEffectiveChain_id(psip2));
}

// format a FASTA style string
ostream& CPDB_seq_id::AsFastaString(ostream& s) const
{
    if (IsSetChain_id()) {
            return s << GetMol().Get() << '|' << GetChain_id();
    }
    // no Upcase per Ostell - Karl 7/2001 
    char chain = (char) GetChain();

    if (chain == '|') {
        return s << GetMol().Get() << '|'; // historically |VB
    } else if ( chain == '\0' ) {
        return s << GetMol().Get() << "| ";
    } 
    return s << GetMol().Get() << '|' << chain; 
}

/*
==================================================
==================================================
*/


string CPDB_seq_id::GetEffectiveChain_id(EBothUnsetPriority bothUnsetPriority) const
{
    //  Use chain's default when neither fields are set
    if (bothUnsetPriority == eBothUnset_Chain && !IsSetChain() && !IsSetChain_id()) {
        return string(char(GetChain()), 1);
    }
    
    return s_GetEffectiveChain_id(*this);
}

bool CPDB_seq_id::IsChainConflict(EConflictMode encodingMode) const
{
    if( IsSetChain() && IsSetChain_id() ) {

        TChain chainChar = (char) GetChain();
		string chain(1, chainChar);
		if (encodingMode == eConflictMode_default || isupper(chainChar) || isdigit(chainChar) ) {
            return (chain != GetChain_id());
		}
        else {

            //  Historic special case: the vertical bar character
            if (chainChar == '|' && GetChain_id() == "VB") {
                return false;
            }

            if (chain == GetChain_id()) {      //  'a' == "a"
                return false;
            } else if (encodingMode == eConflictMode_legacy && islower(chainChar)) {   
                string chainUpperDoubled = chain + chain;
                NStr::ToUpper(chainUpperDoubled);
                return (chainUpperDoubled != GetChain_id());  //  conflict unless 'a' == "AA"
            }
            else {
                return true;  //  unexpected type of conflict
            }
		}
	}
    return false;
}

void CPDB_seq_id::ResetChainIdentifiers(void)
{
    ResetChain_id();
    ResetChain();
}

void CPDB_seq_id::SetChainIdentifiers(const CPDB_seq_id::TChain_id& chainIdentifier)
{
    CTempString chain_id = NStr::TruncateSpaces_Unsafe(chainIdentifier, NStr::eTrunc_Both);

    //  A single space is a valid chain identifier; multiple spaces are not.
    if (chain_id.empty() && chainIdentifier.length() == 1 ) {
        chain_id = " ";
    }

    //  chainIdentifier is either empty or a string of two or more spaces.
    if (chainIdentifier.empty() || chain_id.empty()) {
        ResetChainIdentifiers();
    }
    else if (chain_id.length() == 1) {  //  empty chain_id means chainIdentifier was a single space
    	SetChain( static_cast<unsigned char>(chain_id[0]) );
		SetChain_id(chain_id);
	}
	else {                              // multi-character chain code 
        ResetChain();
        SetChain_id(chain_id);
	}
}

void CPDB_seq_id::SetChainIdentifiers(CPDB_seq_id::TChain chain)
{
    string s(1, (char) chain);
    SetChainIdentifiers(s);
}

END_objects_SCOPE // namespace ncbi::objects::
END_NCBI_SCOPE
